#include "DError.h"

namespace DWL {
    const TCHAR *DError::MensajeError(void) {
        switch (_Error_Numero) {
            case DEnum_Error_SinError :             return TEXT("Sin errores...");
            case DEnum_Error_IndiceInvalido :       return TEXT("El indice especificado no es vlido.");
            case DEnum_Error_ReservandoMemoria :    return TEXT("Error reservando memoria.");
            case DEnum_Error_CreateWindowEx :       return TEXT("La funcin CreateWindowEx retornado NULL, consulta GetLastError para mas informacin.");
            case DEnum_Error_GetDlgItem :           return TEXT("La funcin GetDlgItem ha retornado NULL, consulta GetLastError para mas informacin.");
            case DEnum_Error_BaseWndNULL :          return TEXT("No se ha especificado una clase DBaseWnd vlida para el control.");
            default :                               return TEXT("Error indefinido.");
        }
    }

    void DError::_AsignarFuncionError(const char *nFuncion) {
//        if (nFuncion != 0) delete [] _Error_Funcion;
        size_t Len = strlen(nFuncion);
//        _Error_Funcion = new TCHAR [Len + 1];
        #if defined UNICODE || defined _UNICODE
            #if _MSC_VER > 1400
                mbstowcs_s(0, _Error_Funcion, 2048, nFuncion, Len + 1);
            #else
                mbstowcs(_Error_Funcion, nFuncion, Len + 1);
            #endif
        #else
            #if _MSC_VER > 1400
                strcpy_s(_Error_Funcion, 2048, nFuncion);
            #else
                strcpy(_Error_Funcion, nFuncion);
            #endif
        #endif
    }
};